#region Using declarations
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.ComponentModel;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Average Cumulative Tick Index
    /// </summary>
    [Description("Average Tick Index")]
	[Gui.Design.DisplayName("Averafe Tick Index")]
    public class DTAverageTickIndex : Indicator
    {
        #region Variables
		private int period = 5;
		private double typAvg = 0;
		private bool beginCalc = false;
        #endregion


        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(new Pen(Color.Blue, 1), PlotStyle.Bar, "CTI"));
            CalculateOnBarClose	= true;
            Overlay				= false;
            PriceTypeSupported	= false;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {	
			

			if (Bars.FirstBarOfSession)
			{
				CTI.Set(0);
				beginCalc = false;
			}
			else
			{

				CTI.Set((High[0] + Low[0] + Close[0]) / 3);
			}
			
			typAvg = 0;
        }

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries CTI
        {
            get { return Values[0]; }
        }

        [Description("Numbers of bars used for calculations")]
        [Category("Parameters")]
        public int Period
        {
            get { return period; }
            set { period = Math.Max(1, value); }
        }
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private DTAverageTickIndex[] cacheDTAverageTickIndex = null;

        private static DTAverageTickIndex checkDTAverageTickIndex = new DTAverageTickIndex();

        /// <summary>
        /// Average Tick Index
        /// </summary>
        /// <returns></returns>
        public DTAverageTickIndex DTAverageTickIndex(int period)
        {
            return DTAverageTickIndex(Input, period);
        }

        /// <summary>
        /// Average Tick Index
        /// </summary>
        /// <returns></returns>
        public DTAverageTickIndex DTAverageTickIndex(Data.IDataSeries input, int period)
        {
            if (cacheDTAverageTickIndex != null)
                for (int idx = 0; idx < cacheDTAverageTickIndex.Length; idx++)
                    if (cacheDTAverageTickIndex[idx].Period == period && cacheDTAverageTickIndex[idx].EqualsInput(input))
                        return cacheDTAverageTickIndex[idx];

            lock (checkDTAverageTickIndex)
            {
                checkDTAverageTickIndex.Period = period;
                period = checkDTAverageTickIndex.Period;

                if (cacheDTAverageTickIndex != null)
                    for (int idx = 0; idx < cacheDTAverageTickIndex.Length; idx++)
                        if (cacheDTAverageTickIndex[idx].Period == period && cacheDTAverageTickIndex[idx].EqualsInput(input))
                            return cacheDTAverageTickIndex[idx];

                DTAverageTickIndex indicator = new DTAverageTickIndex();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Period = period;
                Indicators.Add(indicator);
                indicator.SetUp();

                DTAverageTickIndex[] tmp = new DTAverageTickIndex[cacheDTAverageTickIndex == null ? 1 : cacheDTAverageTickIndex.Length + 1];
                if (cacheDTAverageTickIndex != null)
                    cacheDTAverageTickIndex.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheDTAverageTickIndex = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Average Tick Index
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.DTAverageTickIndex DTAverageTickIndex(int period)
        {
            return _indicator.DTAverageTickIndex(Input, period);
        }

        /// <summary>
        /// Average Tick Index
        /// </summary>
        /// <returns></returns>
        public Indicator.DTAverageTickIndex DTAverageTickIndex(Data.IDataSeries input, int period)
        {
            return _indicator.DTAverageTickIndex(input, period);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Average Tick Index
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.DTAverageTickIndex DTAverageTickIndex(int period)
        {
            return _indicator.DTAverageTickIndex(Input, period);
        }

        /// <summary>
        /// Average Tick Index
        /// </summary>
        /// <returns></returns>
        public Indicator.DTAverageTickIndex DTAverageTickIndex(Data.IDataSeries input, int period)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.DTAverageTickIndex(input, period);
        }
    }
}
#endregion
