#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Enter the description of your new custom indicator here
    /// </summary>
    [Description("Enter the description of your new custom indicator here")]
    public class JTRelativeVolume : Indicator
    {
        #region Variables
        // Wizard generated variables
        // User defined variables (add any user defined variables below)
			private	double	[] 	volAtTime = null;
			private double	[]	avgVolAtTime = null;
			private int		[]	numberOfOccurences = null;
			private double 	tempVol = 0;
			private double	cVol = 0;
			private int 	tempNOC = 0;
			private int	barCounter = 0;
			private double averageVolume = 0;
			private double cumulativeVolume = 0;		
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(Color.FromKnownColor(KnownColor.Plum), PlotStyle.Bar, "CumulativeVolumeDiff"));
            Overlay				= false;
			avgVolAtTime		= new double[4000];
			numberOfOccurences	= new int[4000];
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
            // Use this method for calculating your indicator values. Assign a value to each
            // plot below by replacing 'Close[0]' with your own formula.
			if (FirstTickOfBar) 
			{
				if (Bars.FirstBarOfSession)
				{
					barCounter = 0;
					cVol = 0;
				}
				else
				{
					cVol = cVol + Volume[1];
				}
				barCounter ++;
				//Print("BC " + barCounter);
				tempNOC = numberOfOccurences[barCounter];
				tempVol = avgVolAtTime[barCounter] * numberOfOccurences[barCounter];
				averageVolume = (tempVol / tempNOC);				
			} 
			
            cumulativeVolume = (cVol + Volume[0]);
            numberOfOccurences[barCounter] = tempNOC + 1;
			avgVolAtTime[barCounter] = (cVol + Volume[0] + tempVol) / numberOfOccurences[barCounter];
			CumulativeVolumeDiff.Set(cumulativeVolume - avgVolAtTime[barCounter]);
		}

        #region Properties
        [Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
        [XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
        public DataSeries CumulativeVolumeDiff
        {
            get { return Values[0]; }
        }
		
 
        #endregion
    }


}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private JTRelativeVolume[] cacheJTRelativeVolume = null;

        private static JTRelativeVolume checkJTRelativeVolume = new JTRelativeVolume();

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public JTRelativeVolume JTRelativeVolume()
        {
            return JTRelativeVolume(Input);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public JTRelativeVolume JTRelativeVolume(Data.IDataSeries input)
        {
            if (cacheJTRelativeVolume != null)
                for (int idx = 0; idx < cacheJTRelativeVolume.Length; idx++)
                    if (cacheJTRelativeVolume[idx].EqualsInput(input))
                        return cacheJTRelativeVolume[idx];

            lock (checkJTRelativeVolume)
            {
                if (cacheJTRelativeVolume != null)
                    for (int idx = 0; idx < cacheJTRelativeVolume.Length; idx++)
                        if (cacheJTRelativeVolume[idx].EqualsInput(input))
                            return cacheJTRelativeVolume[idx];

                JTRelativeVolume indicator = new JTRelativeVolume();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                Indicators.Add(indicator);
                indicator.SetUp();

                JTRelativeVolume[] tmp = new JTRelativeVolume[cacheJTRelativeVolume == null ? 1 : cacheJTRelativeVolume.Length + 1];
                if (cacheJTRelativeVolume != null)
                    cacheJTRelativeVolume.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheJTRelativeVolume = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.JTRelativeVolume JTRelativeVolume()
        {
            return _indicator.JTRelativeVolume(Input);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.JTRelativeVolume JTRelativeVolume(Data.IDataSeries input)
        {
            return _indicator.JTRelativeVolume(input);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.JTRelativeVolume JTRelativeVolume()
        {
            return _indicator.JTRelativeVolume(Input);
        }

        /// <summary>
        /// Enter the description of your new custom indicator here
        /// </summary>
        /// <returns></returns>
        public Indicator.JTRelativeVolume JTRelativeVolume(Data.IDataSeries input)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.JTRelativeVolume(input);
        }
    }
}
#endregion
